#include <QDesktopWidget>
#include "mainwindow.h"
#include "ui_mainwindow.h"
#include "audioinputdlg.h"
#include "videoinputdlg.h"
#include "videoqualitydlg.h"


QRETURN on_process_signal_removed( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, PVOID pUserData )
{
    MainWindow* m_pChannelWindow = (MainWindow*)pUserData;

    qDebug("signal removed \n");

    m_pChannelWindow->str_info.sprintf("INFO : No signal detected");

    return QCAP_RT_OK;
}

QRETURN on_process_no_signal_detected( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, PVOID pUserData )
{
    MainWindow* m_pChannelWindow = (MainWindow*)pUserData;

    qDebug("no signal Detected \n");

    m_pChannelWindow->str_info.sprintf("INFO : No signal detected");

    return QCAP_RT_OK;
}

QRETURN on_process_format_changed( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, ULONG nVideoWidth, ULONG nVideoHeight, BOOL bVideoIsInterleaved, double dVideoFrameRate, ULONG nAudioChannels, ULONG nAudioBitsPerSample,  ULONG nAudioSampleFrequency, PVOID pUserData )
{
    MainWindow* m_pChannelWindow = (MainWindow*)pUserData;

    qDebug("format changed Detected \n");

    CHAR strVideoInput[ 64 ] = { 0 };

    CHAR strAudioInput[ 64 ] = { 0 };

    CHAR strFrameType[ 64 ] = { 0 };

    int nVH = 0;

    m_pChannelWindow->m_nVideoWidth = nVideoWidth;

    m_pChannelWindow->m_nVideoHeight = nVideoHeight;

    m_pChannelWindow->m_bVideoIsInterleaved = bVideoIsInterleaved;

    m_pChannelWindow->m_dVideoFrameRate = dVideoFrameRate;

    m_pChannelWindow->m_nAudioChannels = nAudioChannels;

    m_pChannelWindow->m_nAudioBitsPerSample = nAudioBitsPerSample;

    m_pChannelWindow->m_nAudioSampleFrequency = nAudioSampleFrequency;

    m_pChannelWindow->m_nVideoInput = nVideoInput;

    m_pChannelWindow->m_nAudioInput = nAudioInput; 


    if ( nVideoInput == 0 ) { sprintf( strVideoInput, "COMPOSITE" ); }

    if ( nVideoInput == 1 ) { sprintf( strVideoInput, "SVIDEO" ); }

    if ( nVideoInput == 2 ) { sprintf( strVideoInput, "HDMI" );}

    if ( nVideoInput == 3 ) { sprintf( strVideoInput, "DVI_D" );}

    if ( nVideoInput == 4 ) { sprintf( strVideoInput, "COMPONENTS (YCBCR)" );}

    if ( nVideoInput == 5 ) { sprintf( strVideoInput, "DVI_A (RGB / VGA)" );}

    if ( nVideoInput == 6 ) { sprintf( strVideoInput, "SDI" );}

    if ( nVideoInput == 7 ) { sprintf( strVideoInput, "AUTO" );}

    if ( nAudioInput == 0 ) { sprintf( strAudioInput, "EMBEDDED_AUDIO" );}

    if ( nAudioInput == 1 ) { sprintf( strAudioInput, "LINE_IN" );}

    if ( nAudioInput == 2 ) { sprintf( strAudioInput, "SOUNDCARD_MICROPHONE" );}

    if ( nAudioInput == 3 ) { sprintf( strAudioInput, "SOUNDCARD_LINE_IN" );}

    if ( bVideoIsInterleaved == TRUE ) { nVH = nVideoHeight / 2; } else { nVH = nVideoHeight; }

    if ( bVideoIsInterleaved == TRUE ) { sprintf( strFrameType, " I " ); } else { sprintf( strFrameType, " P " ); }

    m_pChannelWindow->str_info.sprintf("INFO : %d x %d%s @%2.3f FPS , %d CH x %d BITS x %d HZ ,  VIDEO INPUT : %s ,  AUDIO INPUT : %s"

                                        ,nVideoWidth, nVH, strFrameType, dVideoFrameRate, nAudioChannels, nAudioBitsPerSample

                                        ,nAudioSampleFrequency, strVideoInput, strAudioInput);

    return QCAP_RT_OK;
}

QRETURN on_process_video_preview( PVOID pDevice, double dSampleTime, BYTE* pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData)
{
    return QCAP_RT_OK;
}

QRETURN on_process_audio_preview( PVOID pDevice, double dSampleTime, BYTE* pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData)
{
    return QCAP_RT_OK;
}

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);

    this->resize(960, 540);

    ui->frame->resize(960, 540);

    this->setFixedSize(960, 540);

    path = QCoreApplication::applicationDirPath();

    m_setupdlg = new setupdlg(this);

    m_setupdlg->show();

    //INITIALIZE MEMBER VARIABLES

    m_hVideoDevice = NULL;

    m_nVideoWidth = 0;

    m_nVideoHeight = 0;

    m_bVideoIsInterleaved = 0;

    m_dVideoFrameRate = 0;

    m_nAudioChannels = 0;

    m_nAudioBitsPerSample = 0;

    m_nAudioSampleFrequency = 0;

    m_nVideoInput = QCAP_INPUT_TYPE_SDI;

    m_nAudioInput = QCAP_INPUT_TYPE_EMBEDDED_AUDIO;

    m_bSupportGPU1 = FALSE;

    m_bSupportGPU2 = FALSE;

    m_bSupportGPU3 = FALSE;

    m_bMP4_11 = TRUE;

    m_bMP4_12 = TRUE;

    m_bMP4_13 = TRUE;

    HwInitialize();
}

MainWindow::~MainWindow()
{
    HwUninitialize();

    delete ui;
}

void MainWindow::HwInitialize()
{
    //CREATE CAPTURE DEVICE

    QCAP_CREATE( "QP0203 PCI", 0, (HWND)ui->frame->winId(), &m_hVideoDevice, TRUE);

    QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK( m_hVideoDevice, on_process_no_signal_detected, this );

    QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK( m_hVideoDevice, on_process_signal_removed, this );

    QCAP_REGISTER_FORMAT_CHANGED_CALLBACK( m_hVideoDevice, on_process_format_changed, this );

    QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK( m_hVideoDevice, on_process_video_preview, this );

    QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK( m_hVideoDevice, on_process_audio_preview, this );

    QCAP_SET_VIDEO_INPUT( m_hVideoDevice, QCAP_INPUT_TYPE_SDI);

    QCAP_SET_AUDIO_SOUND_RENDERER(m_hVideoDevice, 0);

   // QCAP_SET_AUDIO_INPUT( m_hVideoDevice, QCAP_INPUT_TYPE_EMBEDDED_AUDIO);

    QCAP_RUN( m_hVideoDevice );
}

void MainWindow::HwUninitialize()
{
    //DESTROY CAPTURE DEVICE

    if( m_hVideoDevice ) {

        QCAP_STOP( m_hVideoDevice );

        QCAP_DESTROY( m_hVideoDevice );

        m_hVideoDevice= NULL;
    }
}





